package ru.yandex.webmaster3.core.util;

import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.oldwebmaster.compatibility.VerificationStateEnum;
import ru.yandex.oldwebmaster.compatibility.VerificationTypeEnum;
import ru.yandex.webmaster3.core.host.verification.VerificationFailInfo;
import ru.yandex.webmaster3.core.host.verification.VerificationStatus;
import ru.yandex.webmaster3.core.host.verification.VerificationType;

/**
 * @author avhaliullin
 */
public class OldWmcVerificationUtil {
    private static final Logger log = LoggerFactory.getLogger(OldWmcVerificationUtil.class);

    public static Pair<VerificationStateEnum, VerificationTypeEnum>
    convertVerificationInfo(VerificationStatus verificationStatus, VerificationType verificationType, VerificationFailInfo failInfo) {
        VerificationStateEnum state;
        VerificationTypeEnum type = null;
        if (verificationType != null) {
            switch (verificationType) {
                case AUTO:
                    type = VerificationTypeEnum.AUTO;
                    break;
                case DELEGATED:
                    type = VerificationTypeEnum.DELEGATION;
                    break;
                case DNS:
                    type = VerificationTypeEnum.DNS_RECORD;
                    break;
                case HTML_FILE:
                    type = VerificationTypeEnum.HTML_FILE;
                    break;
                case META_TAG:
                    type = VerificationTypeEnum.META_TAG;
                    break;
                case PDD:
                    type = VerificationTypeEnum.PDD_AUTO;
                    break;
                case WHOIS:
                    type = VerificationTypeEnum.WHOIS;
                    break;
                case SELF:
                case IDM:
                    type = VerificationTypeEnum.CHEAT;
                    break;
                case PDD_EMU:
                    type = VerificationTypeEnum.PDD_EXTERNAL;
                    break;
                case UNKNOWN:
                default:
                    log.error("Cannot sync verification with type " + verificationType);
                    return Pair.of(VerificationStateEnum.NEVER_VERIFIED, null);
            }
        }
        if (verificationStatus == null) {
            state = VerificationStateEnum.NEVER_VERIFIED;
        } else {
            switch (verificationStatus) {
                case IN_PROGRESS:
                    state = VerificationStateEnum.IN_PROGRESS;
                    break;
                case INTERNAL_ERROR:
                    state = VerificationStateEnum.UNKNOWN;
                    break;
                case VERIFIED:
                    state = VerificationStateEnum.VERIFIED;
                    break;
                case VERIFICATION_FAILED:
                    if (failInfo == null) {
                        state = VerificationStateEnum.NEVER_VERIFIED;
                    } else {
                        switch (failInfo.getType()) {
                            case DNS_RECORD_NOT_FOUND:
                                state = VerificationStateEnum.DNS_NO_SUCH_ENTRY;
                                break;
                            case META_TAG_NOT_FOUND:
                                state = VerificationStateEnum.META_TAG_VERIFICATION_TAG_NOT_FOUND;
                                break;
                            case PAGE_UNAVAILABLE:
                                if (type == VerificationTypeEnum.META_TAG) {
                                    state = VerificationStateEnum.META_TAG_HTTP_CODE;
                                } else if (type == VerificationTypeEnum.HTML_FILE) {
                                    state = VerificationStateEnum.HTML_FILE_IO_EXCEPTION;
                                } else {
                                    type = null;
                                    state = VerificationStateEnum.NEVER_VERIFIED;
                                }
                                break;
                            case WHOIS_EMAIL_NOT_FOUND:
                                state = VerificationStateEnum.WHOIS_EMAIL_NOT_FOUND;
                                break;
                            case WRONG_HTML_PAGE_CONTENT:
                                state = VerificationStateEnum.HTML_FILE_WRONG_CONTENT;
                                break;

                            case AUTO_VERIFICATION_CANCELLED:
                            case DELEGATION_CANCELLED:
                            case NOT_APPLICABLE_FAIL_INFO:
                            case PDD_VERIFICATION_CANCELLED:
                            case SELF_VERIFICATION_CANCELLED:
                            case TXT_VERIFICATION_NOT_SUPPORTED:
                            default:
                                type = null;
                                state = VerificationStateEnum.NEVER_VERIFIED;
                        }
                    }
                    break;
                default:
                    throw new RuntimeException("Unknown status " + verificationStatus);
            }
        }
        return Pair.of(state, type);
    }
}
