package ru.yandex.webmaster3.core.util;

import ru.yandex.webmaster3.core.util.functional.Functions;

import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

/**
 * @author avhaliullin
 */
public class OptionalUtil {
    public static <T1, R> Optional<R> mapCombine(Optional<T1> opt1, Functions.F1<T1, R> mapper) {
        if (opt1.isPresent()) {
            return Optional.ofNullable(mapper.apply(opt1.get()));
        } else {
            return Optional.empty();
        }
    }

    public static <T1, T2, R> Optional<R> mapCombine(Optional<T1> opt1, Optional<T2> opt2, Functions.F2<T1, T2, R> mapper) {
        if (opt1.isPresent() && opt2.isPresent()) {
            return Optional.ofNullable(mapper.apply(opt1.get(), opt2.get()));
        } else {
            return Optional.empty();
        }
    }

    public static <T1, T2, T3, R> Optional<R> mapCombine(Optional<T1> opt1, Optional<T2> opt2, Optional<T3> opt3, Functions.F3<T1, T2, T3, R> mapper) {
        if (opt1.isPresent() && opt2.isPresent() && opt3.isPresent()) {
            return Optional.ofNullable(mapper.apply(opt1.get(), opt2.get(), opt3.get()));
        } else {
            return Optional.empty();
        }
    }

    public static <T1, T2, T3, T4, R> Optional<R> mapCombine(Optional<T1> opt1, Optional<T2> opt2, Optional<T3> opt3, Optional<T4> opt4, Functions.F4<T1, T2, T3, T4, R> mapper) {
        if (opt1.isPresent() && opt2.isPresent() && opt3.isPresent() && opt4.isPresent()) {
            return Optional.ofNullable(mapper.apply(opt1.get(), opt2.get(), opt3.get(), opt4.get()));
        } else {
            return Optional.empty();
        }
    }

    public static <T1, T2, T3, T4, T5, R> Optional<R> mapCombine(Optional<T1> opt1, Optional<T2> opt2, Optional<T3> opt3, Optional<T4> opt4, Optional<T5> opt5, Functions.F5<T1, T2, T3, T4, T5, R> mapper) {
        if (opt1.isPresent() && opt2.isPresent() && opt3.isPresent() && opt4.isPresent() && opt5.isPresent()) {
            return Optional.ofNullable(mapper.apply(opt1.get(), opt2.get(), opt3.get(), opt4.get(), opt5.get()));
        } else {
            return Optional.empty();
        }
    }

    public static <T1, T2, T3, T4, T5, T6, R> Optional<R> mapCombine(Optional<T1> opt1, Optional<T2> opt2, Optional<T3> opt3, Optional<T4> opt4, Optional<T5> opt5, Optional<T6> opt6, Functions.F6<T1, T2, T3, T4, T5, T6, R> mapper) {
        if (opt1.isPresent() && opt2.isPresent() && opt3.isPresent() && opt4.isPresent() && opt5.isPresent() && opt6.isPresent()) {
            return Optional.ofNullable(mapper.apply(opt1.get(), opt2.get(), opt3.get(), opt4.get(), opt5.get(), opt6.get()));
        } else {
            return Optional.empty();
        }
    }

    public static <T1, T2, T3, T4, T5, T6, T7, R> Optional<R> mapCombine(Optional<T1> opt1, Optional<T2> opt2, Optional<T3> opt3, Optional<T4> opt4, Optional<T5> opt5, Optional<T6> opt6, Optional<T7> opt7, Functions.F7<T1, T2, T3, T4, T5, T6, T7, R> mapper) {
        if (opt1.isPresent() && opt2.isPresent() && opt3.isPresent() && opt4.isPresent() && opt5.isPresent() && opt6.isPresent() && opt7.isPresent()) {
            return Optional.ofNullable(mapper.apply(opt1.get(), opt2.get(), opt3.get(), opt4.get(), opt5.get(), opt6.get(), opt7.get()));
        } else {
            return Optional.empty();
        }
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Optional<R> mapCombine(Optional<T1> opt1, Optional<T2> opt2, Optional<T3> opt3, Optional<T4> opt4, Optional<T5> opt5, Optional<T6> opt6, Optional<T7> opt7, Optional<T8> opt8, Functions.F8<T1, T2, T3, T4, T5, T6, T7, T8, R> mapper) {
        if (opt1.isPresent() && opt2.isPresent() && opt3.isPresent() && opt4.isPresent() && opt5.isPresent() && opt6.isPresent() && opt7.isPresent() && opt8.isPresent()) {
            return Optional.ofNullable(mapper.apply(opt1.get(), opt2.get(), opt3.get(), opt4.get(), opt5.get(), opt6.get(), opt7.get(), opt8.get()));
        } else {
            return Optional.empty();
        }
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Optional<R> mapCombine(Optional<T1> opt1, Optional<T2> opt2, Optional<T3> opt3, Optional<T4> opt4, Optional<T5> opt5, Optional<T6> opt6, Optional<T7> opt7, Optional<T8> opt8, Optional<T9> opt9, Functions.F9<T1, T2, T3, T4, T5, T6, T7, T8, T9, R> mapper) {
        if (opt1.isPresent() && opt2.isPresent() && opt3.isPresent() && opt4.isPresent() && opt5.isPresent() && opt6.isPresent() && opt7.isPresent() && opt8.isPresent() && opt9.isPresent()) {
            return Optional.ofNullable(mapper.apply(opt1.get(), opt2.get(), opt3.get(), opt4.get(), opt5.get(), opt6.get(), opt7.get(), opt8.get(), opt9.get()));
        } else {
            return Optional.empty();
        }
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, R> Optional<R> mapCombine(Optional<T1> opt1, Optional<T2> opt2, Optional<T3> opt3, Optional<T4> opt4, Optional<T5> opt5, Optional<T6> opt6, Optional<T7> opt7, Optional<T8> opt8, Optional<T9> opt9, Optional<T10> opt10, Functions.F10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, R> mapper) {
        if (opt1.isPresent() && opt2.isPresent() && opt3.isPresent() && opt4.isPresent() && opt5.isPresent() && opt6.isPresent() && opt7.isPresent() && opt8.isPresent() && opt9.isPresent() && opt10.isPresent()) {
            return Optional.ofNullable(mapper.apply(opt1.get(), opt2.get(), opt3.get(), opt4.get(), opt5.get(), opt6.get(), opt7.get(), opt8.get(), opt9.get(), opt10.get()));
        } else {
            return Optional.empty();
        }
    }


    private static void generateMapCombine(StringBuilder sb, int size) {
        Supplier<IntStream> rangeSup = () -> IntStream.range(1, size + 1);
        String typeList = rangeSup.get().mapToObj(i -> "T" + i).collect(Collectors.joining(", ")) + ", R";
        String optList = rangeSup.get().mapToObj(i -> String.format("Optional<T%1$d> opt%1$d", i)).collect(Collectors.joining(", "));
        String presentCheck = rangeSup.get().mapToObj(i -> String.format("opt%d.isPresent()", i)).collect(Collectors.joining(" && "));
        String optUnpack = rangeSup.get().mapToObj(i -> String.format("opt%d.get()", i)).collect(Collectors.joining(", "));
        sb.append(String.format("public static <%1$s> Optional<R> mapCombine(%2$s, Functions.F%3$d<%1$s> mapper) {\n", typeList, optList, size))
                .append(String.format("if (%s) {\n", presentCheck))
                .append(String.format("return Optional.ofNullable(mapper.apply(%s));\n", optUnpack))
                .append("} else {\n")
                .append("return Optional.empty();\n")
                .append("}\n")
                .append("}\n");
    }

    private static void main(String[] args) {
        StringBuilder sb = new StringBuilder();
        for (int size = 1; size <= 10; size++) {
            generateMapCombine(sb, size);
            sb.append("\n");
        }
        System.out.print(sb.toString());
    }
}
