package ru.yandex.webmaster3.core.util;

import javax.annotation.Nullable;
import java.time.Duration;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

/**
 * @author avhaliullin
 */
public class ProfilingWatch {
    private final long start = System.nanoTime();
    private final SortedMap<Long, String> marks = new TreeMap<>();

    @Nullable
    private Duration warnDuration = null;

    public ProfilingWatch() {
    }

    public ProfilingWatch(@Nullable Duration warnDuration) {
        this.warnDuration = warnDuration;
    }

    public void mark(String eventName) {
        marks.put(System.nanoTime() - start, eventName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        long prev = 0;
        long total = marks.isEmpty() ? 0L : marks.lastKey();
        if (warnDuration != null && total > warnDuration.toNanos()) {
            sb.append("WARN ");
        }

        sb.append("total=").append(TimeUnit.NANOSECONDS.toMillis(total));

        for (Map.Entry<Long, String> entry : marks.entrySet()) {
            long cur = entry.getKey();
            sb.append(" ").append(entry.getValue()).append("=").append(TimeUnit.NANOSECONDS.toMillis(cur - prev));
            prev = cur;
        }


        return sb.toString();
    }
}
