package ru.yandex.webmaster3.core.util;

import com.google.common.math.LongMath;
import org.apache.commons.lang3.mutable.MutableLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.RoundingMode;

/**
 * @author aherman
 */
public class ProgressUtils {
    private static final Logger log = LoggerFactory.getLogger(ProgressUtils.class);

    public static final int MILLIS_IN_HOUR = 3600000;
    public static final int MILLIS_IN_MINUTE = 60000;
    public static final int MILLIS_IN_SECOND = 1000;

    public static String formatTime(long expMillis) {
        if (expMillis < MILLIS_IN_SECOND) {
            return String.format("%d ms", expMillis);
        } else if (expMillis < MILLIS_IN_MINUTE) {
            return String.format("%.2f s", expMillis * 1.0f / MILLIS_IN_SECOND);
        } else if (expMillis < MILLIS_IN_HOUR) {
            long minutes = LongMath.divide(expMillis, MILLIS_IN_MINUTE, RoundingMode.DOWN);
            long seconds = LongMath.mod(expMillis, MILLIS_IN_MINUTE) / MILLIS_IN_SECOND;
            return String.format("00:%02d:%02d", minutes, seconds);
        }
        long hours = LongMath.divide(expMillis, MILLIS_IN_HOUR, RoundingMode.DOWN);
        expMillis = LongMath.mod(expMillis, MILLIS_IN_HOUR);
        long minutes = LongMath.divide(expMillis, MILLIS_IN_MINUTE, RoundingMode.DOWN);
        long seconds = LongMath.mod(expMillis, MILLIS_IN_MINUTE) / MILLIS_IN_SECOND;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    public static ProgressLogger progressTracker(long logDensity, String message) {
        MutableLong counter = new MutableLong(0L);
        return new ProgressLogger() {
            @Override
            public void trackProgress() {
                if ((counter.incrementAndGet() % logDensity) == 0) {
                    logState();
                }
            }

            @Override
            public void logState() {
                log.info(message + ": " + counter.getValue());
            }
        };
    }
}
