package ru.yandex.webmaster3.core.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

/**
 * @author avhaliullin
 */
public class URLEncodeUtil {
    private static final String ENCODING = "UTF-8";

    public static String urlEncode(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLEncoder.encode(s, ENCODING).replace("+", "%20");
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Should never happen: urlencode failed", e);
        }
    }

    public static String urlDecode(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLDecoder.decode(s, ENCODING);
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Should never happen: urldecode failed", e);
        }
    }

    public static String urlDecodeSafe(String s) {
        try {
            return urlDecode(s);
        } catch (RuntimeException e) {
            return s;
        }
    }

    public static String prettifyUrl(String s) {
        if (s == null) {
            return null;
        }
        return urlDecode(s.replaceAll("%(?![0-9a-fA-F]{2})", "%25"));//negative lookahead
    }

    private URLEncodeUtil() {
    }
}
