package ru.yandex.webmaster3.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import java.util.function.Supplier;

/**
 * @author avhaliullin
 */
public class W3CollectionUtils {

    public static <T> T getRandomItem(List<T> list) {
        return list.get(ThreadLocalRandom.current().nextInt(list.size()));
    }

    public static <K, V, M extends Map<K, V>> void mergeInPlace(
            Map<K, V> m1,
            Map<? extends K, ? extends V> m2,
            BiFunction<? super V, ? super V, ? extends V> merge) {
        for (Map.Entry<? extends K, ? extends V> entry : m2.entrySet()) {
            m1.merge(entry.getKey(), entry.getValue(), merge);
        }
    }

    public static <K, V, M extends Map<K, V>> M mergeToMap(
            Map<? extends K, ? extends V> m1,
            Map<? extends K, ? extends V> m2,
            BiFunction<? super V, ? super V, ? extends V> merge,
            Supplier<M> mapSupplier) {
        M result = mapSupplier.get();
        result.putAll(m1);
        mergeInPlace(result, m2, merge);
        return result;
    }

    public static <K, V> Map<K, V> mergeToHashMap(
            Map<? extends K, ? extends V> m1,
            Map<? extends K, ? extends V> m2,
            BiFunction<? super V, ? super V, ? extends V> merge) {
        return mergeToMap(m1, m2, merge, HashMap::new);
    }

    public static <T> List<T> varargToList(T a1, T... args) {
        List<T> result = new ArrayList<>(args.length + 1);
        result.add(a1);
        result.addAll(Arrays.asList(args));
        return result;
    }

    public static <T> List<T> truncate(List<T> list, int limit) {
        return list.subList(0, Math.min(list.size(), limit));
    }
}
