package ru.yandex.webmaster3.core.util;

import java.io.ByteArrayOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.google.common.base.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

/**
 * @author avhaliullin
 */
public class XmlUtil {
//    private static final Logger log = LoggerFactory.getLogger(XmlUtil.class);
//
//    private static final TransformerFactory transformerFactory = new TransformerFactoryImpl();

    /**
     * Создает XmlConvertable на основе проаннотированного объекта
     *
     * @param jaxbObject проаннотированный объект (@XmlRootElement, @XmlElement, ...)
     * @param <T> тип передаваемого объекта
     * @return XmlConvertable обертка объекта
     */
//    public static <T> XmlConvertable xmlConvertable(final T jaxbObject) throws JAXBException {
//        final JAXBContext context = JAXBContext.newInstance(jaxbObject.getClass());
//        final Marshaller marshaller = context.createMarshaller();
//        // Выводим форматированный xml
//        marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
//        // Позволяет не выводить преамбулу <?xml version=... ?>
//        marshaller.setProperty(Marshaller.JAXB_FRAGMENT, true);
//        return new XmlConvertable() {
//            @Override
//            public void toXml(StringBuilder storage) {
//                StringWriter writer = new StringWriter();
//                try {
//                    marshaller.marshal(jaxbObject, writer);
//                    storage.append(writer.getBuffer());
//                } catch (JAXBException e) {
//                    log.error("Exception during jaxb marshalling ", e);
//                }
//            }
//        };
//    }

    private static final Pattern XML_STRING_PATTERN = Pattern.compile(
            "^[\\u0009-\\u000A\\u000D\\u0020-\\uD7FF]*$",
            Pattern.UNICODE_CASE
    );

    /**
     * Проверяет допустимость символов строки в xml
     *
     * @param data  проверяемая строка
     * @return      результат проверки: true, если все символы строки допустимы
     */
    public static boolean isValidXmlString(final String data) {
        Matcher m = XML_STRING_PATTERN.matcher(data);
        return m.matches();
    }

    /**
     * Фильтрует символы строки, оставляя только символы, допустимые стандартом XML 1.0
     *
     * @param in входная строка, возможно содержащая недопустимые символы
     * @return строка, содержащая только допустимые символы
     */
    public static String stripInvalidXMLCharacters(String in) {
        StringBuilder out = new StringBuilder(); // Used to hold the output.
        char current; // Used to reference the current character.

        if (StringUtils.isEmpty(in)) {
            return "";
        }
        for (int i = 0; i < in.length(); i++) {
            current = in.charAt(i);
            if ((current >= 0x9) && (current <= 0xA) ||
                    (current == 0xD) ||
                    ((current >= 0x20) && (current <= 0xD7FF)) ||
                    ((current >= 0xE000) && (current <= 0xFFFD)) ||
                    ((current >= 0x10000) && (current <= 0x10FFFF)))
            {
                out.append(current);
            }
        }
        return out.toString();
    }

    public static byte[] serializeDocument(Document document) {
        return serializeDocument(document.getDocumentElement());
    }

    public static byte[] serializeDocument(Node node) {
        // сериализуем в строку
        DOMImplementationLS domImplementationLS = (DOMImplementationLS) node.getOwnerDocument().getImplementation();
        LSOutput output = domImplementationLS.createLSOutput();
        LSSerializer serializer = domImplementationLS.createLSSerializer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        output.setEncoding(Charsets.UTF_8.name());
        output.setByteStream(baos);
        serializer.write(node, output);
        return baos.toByteArray();
    }
}
