package ru.yandex.webmaster3.core.util;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.webmaster3.core.zora.data.response.ZoraUrlFetchResponse;
import ru.yandex.wmtools.common.error.InternalException;

/**
 * @author avhaliullin
 */
public class ZoraResponseDocumentUtil {
    private static final Logger log = LoggerFactory.getLogger(ZoraResponseDocumentUtil.class);

    public static String getResponseString(ZoraUrlFetchResponse response) throws IOException, InternalException {
        String documentContent = null;
        if (response.hasDocument()) {

            Charset charset = response.getCharsetJava();
            documentContent = StringUtils.trimToEmpty(response.getDocumentContentAsString(charset));
        }
        return documentContent;
    }

    public static List<String> getRedirectsList(ZoraUrlFetchResponse response) {
        return response.getSitaRedirectInfo().getRedirects()
                .stream()
                .map(Object::toString)
                .collect(Collectors.toList());
    }
}
