package ru.yandex.webmaster3.core.util.concurrent.graph;

import ru.yandex.webmaster3.core.util.RetryUtils;
import ru.yandex.webmaster3.core.util.functional.Functions;
import ru.yandex.webmaster3.core.util.functional.ThrowingConsumer;
import ru.yandex.webmaster3.core.util.functional.ThrowingFunction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

/**
 * @author avhaliullin
 */
public interface BlockingBatchConsumer<T> {
    void accept(List<T> batch) throws Exception;

    static <In, Out> Functions.F1<GraphOutQueue<Out>, BlockingBatchConsumer<In>> mapping(RetryUtils.RetryPolicy retryPolicy,
                                                                                         FailPolicy failPolicy, ThrowingFunction<In, Out, Exception> mapper) {
        return q -> mapping(q, retryPolicy, failPolicy, mapper);
    }

    static <In, Out> BlockingBatchConsumer<In> mapping(GraphOutQueue<Out> out, RetryUtils.RetryPolicy retryPolicy,
                                                       FailPolicy failPolicy, ThrowingFunction<In, Out, Exception> mapper) {
        return new MappingConsumerImpl<>(out, retryPolicy, failPolicy, mapper);
    }

    static <T> Functions.F1<GraphOutQueue<T>, BlockingBatchConsumer<T>> filtering(Predicate<T> predicate) {
        return q -> filtering(q, predicate);
    }

    static <T> BlockingBatchConsumer<T> filtering(GraphOutQueue<T> out, Predicate<T> predicate) {
        return new FilteringConsumerImpl<>(out, predicate);
    }

    static <In> BlockingBatchConsumer<In> perItem(RetryUtils.RetryPolicy retryPolicy, FailPolicy failPolicy, ThrowingConsumer<In, Exception> consumer) {
        return new PerItemConsumerImpl<>(retryPolicy, failPolicy, consumer);
    }

    static <T> BlockingBatchConsumer<T> multiplexing(GraphOutQueue<T> out1, GraphOutQueue<T>... outs) {
        List<GraphOutQueue<T>> outsList = new ArrayList<>(outs.length + 1);
        outsList.add(out1);
        outsList.addAll(Arrays.asList(outs));
        return new MultiplexingConsumer<>(outsList);
    }
}
