package ru.yandex.webmaster3.core.util.concurrent.graph;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.function.Consumer;

public interface FailPolicy {
    <SE extends Exception> void handle(SE exception) throws SE;

    FailPolicy THROW = new FailPolicy() {
        @Override
        public <E extends Exception> void handle(E exception) throws E {
            throw exception;
        }
    };
    FailPolicy LOG = new FailPolicy() {
        private final Logger log = LoggerFactory.getLogger(getClass());

        @Override
        public <E extends Exception> void handle(E exception) throws E {
            log.error("Skipping error", exception);
        }
    };

    static FailPolicy tracking(Consumer<Exception> handler) {
        return new FailPolicy() {
            @Override
            public <E extends Exception> void handle(E exception) {
                handler.accept(exception);
            }
        };
    }
}
