package ru.yandex.webmaster3.core.util.concurrent.graph;

import java.util.List;
import java.util.function.Predicate;

/**
 * @author avhaliullin
 */
public class FilteringConsumerImpl<T> implements BlockingBatchConsumer<T> {
    private final GraphOutQueue<T> out;
    private final Predicate<T> predicate;

    public FilteringConsumerImpl(GraphOutQueue<T> out, Predicate<T> predicate) {
        this.out = out;
        this.predicate = predicate;
    }

    @Override
    public void accept(List<T> batch) throws Exception {
        for (T item : batch) {
            if (predicate.test(item)) {
                out.put(item);
            }
        }
    }
}
