package ru.yandex.webmaster3.core.util.concurrent.graph;

import java.util.List;

/**
 * @author avhaliullin
 */
public class MultiplexingConsumer<T> implements BlockingBatchConsumer<T> {
    private final List<GraphOutQueue<T>> outs;

    public MultiplexingConsumer(List<GraphOutQueue<T>> outs) {
        this.outs = outs;
    }

    @Override
    public void accept(List<T> batch) throws Exception {
        for (T item : batch) {
            for (GraphOutQueue<T> out : outs) {
                out.put(item);
            }
        }
    }
}
