package ru.yandex.webmaster3.core.util.concurrent.graph;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.webmaster3.core.util.RetryUtils;
import ru.yandex.webmaster3.core.util.functional.ThrowingConsumer;

import java.util.List;

/**
 * @author avhaliullin
 */
public class PerItemConsumerImpl<In> implements BlockingBatchConsumer<In> {
    private static final Logger log = LoggerFactory.getLogger(PerItemConsumerImpl.class);

    private final ThrowingConsumer<In, Exception> consumer;
    private final RetryUtils.RetryPolicy retryPolicy;
    private final FailPolicy failPolicy;

    public PerItemConsumerImpl(RetryUtils.RetryPolicy retryPolicy, FailPolicy failPolicy, ThrowingConsumer<In, Exception> consumer) {
        this.consumer = consumer;
        this.retryPolicy = retryPolicy;
        this.failPolicy = failPolicy;
    }

    @Override
    public void accept(List<In> batch) throws Exception {
        for (In item : batch) {
            try {
                RetryUtils.execute(retryPolicy, () -> consumer.accept(item));
            } catch (Exception e) {
                failPolicy.handle(e);
            }
        }
    }
}
