package ru.yandex.webmaster3.core.util.conductor;

import java.util.List;

import org.springframework.beans.factory.annotation.Required;

/**
 * @author tsyplyaev
 */
public class ConductorClientForService extends ConductorClientForGroup {
    private int port;

    @Override
    public List<ConductorHostInfo> listHostsInGroup() throws ConductorException {
        List<ConductorHostInfo> result = super.listHostsInGroup();
        for (ConductorHostInfo c : result) {
            c.setPort(port);
        }
        return result;
    }

    @Required
    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return port;
    }
}
