package ru.yandex.webmaster3.core.util.conductor;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author aherman
 */
public class ConductorHostInfo {
    private final String hostName;
    private final String datacenterName;
    private final String rootDatacenterName;

    private Integer port;

    public ConductorHostInfo(
            @JsonProperty("fqdn") String hostName,
            @JsonProperty("datacenter_name") String datacenterName,
            @JsonProperty("root_datacenter_name") String rootDatacenterName)
    {
        this.hostName = hostName;
        this.datacenterName = datacenterName;
        this.rootDatacenterName = rootDatacenterName;
    }

    public String getHostName() {
        return hostName;
    }

    public String getDatacenterName() {
        return datacenterName;
    }

    public String getRootDatacenterName() {
        return rootDatacenterName;
    }

    public Integer getPort() {
        return port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }
}
