package ru.yandex.webmaster3.core.util.enums;

import java.util.Map;

import ru.yandex.common.util.collections.Cf;

/**
 * @author Ildar Safarov
 */
public class IntEnumResolver<T extends Enum<T> & IntEnum> extends AbstractIntEnumResolver<T> {

    private final Map<Integer, T> mapByValue;

    protected IntEnumResolver(Class<T> enumClass) {
        super(enumClass);

        mapByValue = Cf.newHashMap();
        for (T t : valuesList) {
            mapByValue.put(t.value(), t);
        }
    }

    @Override
    public T fromValueOrNull(int value) {
        return mapByValue.get(value);
    }

    public static <T extends Enum<T> & IntEnum> IntEnumResolver<T> r(Class<T> enumClass) {
        return new IntEnumResolver<T>(enumClass);
    }
}