package ru.yandex.webmaster3.core.util.functional;

import java.util.function.Function;

/**
 * @author avhaliullin
 */
@FunctionalInterface
public interface ThrowingFunction<T, R, E extends Exception> {
    R apply(T item) throws E;

    static <T, R, E extends Exception> Function<T, R> rethrowingUnchecked(ThrowingFunction<T, R, E> c) {
        return v -> {
            try {
                return c.apply(v);
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }
}
