package ru.yandex.webmaster3.core.util.joda.jackson;

import java.io.IOException;
import java.util.BitSet;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;

/**
 * Created by Oleg Bazdyrev on 12/01/2022.
 */
public class BitSetSerializer extends StdSerializer<BitSet> {

    public BitSetSerializer() {
        super(BitSet.class);
    }

    @Override
    public void serialize(BitSet value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        long[] data = value.toLongArray();
        gen.writeStartArray(data.length);
        for (long v : data) {
            gen.writeNumber(v);
        }
        gen.writeEndArray();
    }


}
