package ru.yandex.webmaster3.core.util.joda.jackson;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.KeyDeserializer;
import org.apache.commons.lang3.StringUtils;
import ru.yandex.webmaster3.core.util.joda.DurationSerializationUtil;

import java.io.IOException;

public class WebmasterDurationKeyDeserializer extends KeyDeserializer {
    private final boolean deserializeCompatible;

    public WebmasterDurationKeyDeserializer(boolean deserializeCompatible) {
        this.deserializeCompatible = deserializeCompatible;
    }

    @Override
    public Object deserializeKey(String key, DeserializationContext ctxt) throws IOException {
        if (StringUtils.isEmpty(key)) {
            return null;
        }
        return deserializeCompatible ? DurationSerializationUtil.deserializeCompatible(key) : DurationSerializationUtil.deserializeDuration(key);
    }
}
