package ru.yandex.webmaster3.core.util.joda.jackson;

import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.joda.PackageVersion;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import org.joda.time.Duration;

/**
 * @author avhaliullin
 */
public class WebmasterDurationModule extends SimpleModule {
    public WebmasterDurationModule(boolean deserializeCompatible) {
        super(PackageVersion.VERSION);
        addDeserializer(Duration.class, new WebmasterDurationDeserializer(deserializeCompatible));
        addSerializer(Duration.class, new WebmasterDurationSerializer(FormatConfig.DEFAULT_DATEONLY_FORMAT));
        addKeyDeserializer(Duration.class, new WebmasterDurationKeyDeserializer(deserializeCompatible));
    }

    @Override
    public String getModuleName() {
        return getClass().getSimpleName();
    }

    @Override
    public int hashCode() {
        return getClass().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }
}
