package ru.yandex.webmaster3.core.util.joda.spring;

import org.joda.time.Duration;
import ru.yandex.webmaster3.core.util.joda.DurationSerializationUtil;

import java.beans.PropertyEditorSupport;
import java.util.regex.Pattern;

/**
 * @author avhaliullin
 */
public class JodaDurationPropertyEditor extends PropertyEditorSupport {
    private static final Pattern PATTERN = Pattern.compile("^(\\d+)(\\w+)$");

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        setValue(DurationSerializationUtil.deserializeDuration(text));
    }

    @Override
    public String getAsText() {
        Object obj = getValue();
        if (obj instanceof Duration) {
            return DurationSerializationUtil.serializeDuration((Duration) obj);
        }
        return null;
    }
}
