package ru.yandex.webmaster3.core.util.json.polymorphic;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import com.fasterxml.jackson.databind.annotation.JsonTypeResolver;

/**
 * @author avhaliullin
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM,
        include = JsonTypeInfo.As.EXISTING_PROPERTY,
        property = "type")
@JsonTypeIdResolver(DiscriminatorBasedTypeResolver.class)
@JsonTypeResolver(DefaultValuedTypeResolverBuilder.class)
public interface Polymorphic<D extends Enum<D> & Discriminator<? extends Polymorphic<D>>> {
    D getType();
}
