package ru.yandex.webmaster3.core.util.trie;

import java.util.function.Consumer;

/**
 * Created by ifilippov5 on 16.10.17.
 */
public class CompactTrieMap<E, T> {

    private final CompactTrie<T> trie;
    private final IDataConverter<E> keyConverter;

    public CompactTrieMap(CompactTrie<T> trie, IDataConverter<E> keyConverter) {
        this.trie = trie;
        this.keyConverter = keyConverter;
    }

    public boolean contains(E key) {
        return trie.contains(keyConverter.toRawData(key));
    }

    public T get(E key) {
        return trie.get(keyConverter.toRawData(key));
    }

    public void foreachKey(Consumer<E> consumer) {
        trie.foreach(null, (key, keyLen) -> {
            consumer.accept(keyConverter.fromRawData(key, keyLen));
        });
    }

    public void foreachEntry(EntryConsumer<E, T> consumer) {
        trie.foreach((key, keyLen, value) -> {
            consumer.accept(keyConverter.fromRawData(key, keyLen), value);
        }, null);
    }

    public int getDataSizeBytes() {
        return trie.getDataSizeBytes();
    }

    public interface EntryConsumer<E, T> {
        void accept(E key, T value);
    }
}
