package ru.yandex.webmaster3.core.util.trie;

import java.util.UUID;

/**
 * @author leonidrom
 */
public class UUIDDriver implements TrieValueCodec<UUID> {
    private final int LEN_BYTES = 16;

    @Override
    public int write(UUID value, TrieBufferWriter buffer, int offset) {
        offset = buffer.writeLong(offset, value.getMostSignificantBits());
        return buffer.writeLong(offset, value.getLeastSignificantBits());
    }

    @Override
    public UUID read(TrieBufferReader data) {
        return new UUID(data.readLong(), data.readLong());
    }

    @Override
    public void skip(TrieBufferReader data) {
        data.skip(LEN_BYTES);
    }
}
