package ru.yandex.webmaster3.core.util.yson;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.io.IOContext;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;

/**
 * @author avhaliullin
 */
public class YsonFactory extends JsonFactory {
    @Override
    public ToBinaryYsonGenerator createGenerator(OutputStream out) throws IOException {
        return createGenerator(out, JsonEncoding.UTF8);
    }

    @Override
    public ToBinaryYsonGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        YsonBinaryStreamWriter streamWriter = new YsonBinaryStreamWriter(out);
        return new ToBinaryYsonGenerator(_factoryFeatures, _objectCodec, streamWriter);
    }

    @Override
    public ToBinaryYsonGenerator createGenerator(Writer out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @SuppressWarnings("resource")
    @Override
    public ToBinaryYsonGenerator createGenerator(File f, JsonEncoding enc) throws IOException {
        OutputStream out = new FileOutputStream(f);
        return createGenerator(out, enc);
    }

    @Override
    protected YsonToJsonParser _createParser(InputStream in, IOContext ctxt) throws IOException {
        return new YsonToJsonParser(ctxt, _parserFeatures, new YsonBinaryStreamReader(in));
    }
}
