package ru.yandex.webmaster3.core.util.yson;

import java.util.Arrays;

/**
 * @author avhaliullin
 */
enum YsonNodeTypeTag {
    STRING(0x01),
    INT64(0x02),
    DOUBLE(0x03),
    BOOL_FALSE(0x04),
    BOOL_TRUE(0x05),
    UINT64(0x06),;
    final byte value;

    YsonNodeTypeTag(int value) {
        this.value = (byte) value;
    }

    private static final YsonNodeTypeTag[] VALUE_BY_TAG;

    static {
        int maxValue = Arrays.stream(values()).mapToInt(tag -> tag.value).max().getAsInt();
        VALUE_BY_TAG = new YsonNodeTypeTag[maxValue + 1];
        for (YsonNodeTypeTag tag : values()) {
            VALUE_BY_TAG[tag.value] = tag;
        }
    }

    public static YsonNodeTypeTag getByTag(int tag) {
        return tag < 0 || tag >= VALUE_BY_TAG.length ? null : VALUE_BY_TAG[tag];
    }
}
