package ru.yandex.webmaster3.core.util.yson.tokens;

import java.util.Arrays;
import java.util.IntSummaryStatistics;

/**
 * @author avhaliullin
 */
public enum YsonControlToken implements IYsonToken {
    MAP_START('{'),
    MAP_END('}'),
    LIST_START('['),
    LIST_END(']'),
    DELIMITER(';'),
    ENTITY('#'),
    EQ('='),
    ;
    private final char character;

    YsonControlToken(char character) {
        this.character = character;
    }

    public char getCharacter() {
        return character;
    }

    public static YsonControlToken fromCharacter(char character) {
        character -= CHAR_TO_CONTROL_SHIFT;
        return character < 0 || character >= CHAR_TO_CONTROL_TOKEN.length ? null : CHAR_TO_CONTROL_TOKEN[character];
    }

    private static final YsonControlToken[] CHAR_TO_CONTROL_TOKEN;
    private static final int CHAR_TO_CONTROL_SHIFT;

    static {
        IntSummaryStatistics summary = Arrays.stream(values()).mapToInt(YsonControlToken::getCharacter).summaryStatistics();
        CHAR_TO_CONTROL_SHIFT = summary.getMin();
        CHAR_TO_CONTROL_TOKEN = new YsonControlToken[summary.getMax() - summary.getMin() + 1];
        for (YsonControlToken token : values()) {
            CHAR_TO_CONTROL_TOKEN[token.getCharacter() - summary.getMin()] = token;
        }
    }

}
