package ru.yandex.webmaster3.core.util.yson.tokens;

/**
 * @author avhaliullin
 */
public final class YsonToken {
    private YsonToken() {
    }

    public static YsonBooleanToken createBoolean(boolean value) {
        return value ? YsonBooleanToken.TRUE_NODE : YsonBooleanToken.FALSE_NODE;
    }

    public static YsonInt64Token createSigned(long value) {
        return new YsonInt64Token(value, true);
    }

    public static YsonInt64Token createUnsigned(long value) {
        return new YsonInt64Token(value, false);
    }

    public static YsonDoubleToken createDouble(double value) {
        return new YsonDoubleToken(value);
    }

    public static YsonStringToken createString(byte[] data) {
        return new YsonStringToken(data);
    }

    public static YsonControlToken createControlToken(int value) {
        return YsonControlToken.fromCharacter((char) value);
    }
}
