package ru.yandex.webmaster3.core.validator;

import ru.yandex.common.util.collections.Cf;

import java.util.Map;

/**
 * User: Vladislav Dolbilov (darl@yandex-team.ru)
 * Date: 15.02.12 12:54
 */
public enum XmlValidatorSchema {
    AUTO(1, "auto.xsd"),
    AUTO_REGIONAL(2, "auto-regional.xsd"),
    REALTY(3, "realty.xsd"),
    RECIPE(4, "recipe.xsd"),
    REFERAT(5, "referat.xsd"),
    RABOTA(6, "rabota.xsd"),
    USLUGI(7, "bank-product.xsd"),
    VIDEO(8, "video.xsd"),
    BUSINESS_REVIEW(9, "review-biz.xsd"),
    SHOPS(10, "shops.xsd"),
    AUTO_REVIEW(11, "auto-reviews.xsd"),
    SPRAVOCHNIK(12, "spravochnik.xsd"),
    TIMETABLE(13, "timetable.xsd"),
    TURBO_FEED(14, "turbo-feed-yandex.xsd", "turbo-feed-turbo.xsd", "turbo-feed-media.xsd", "turbo-feed.xsd"),
    AUTOPARTS(15, "autoparts.xsd"),
    ;

    private static final Map<Integer, String[]> codeToSchemas = Cf.newHashMap();

    static {
        for (XmlValidatorSchema s : XmlValidatorSchema.values()) {
            codeToSchemas.put(s.code, s.schemaNames);
        }
    }

    final int code;
    final String[] schemaNames;

    XmlValidatorSchema(int code, String... schemaNames) {
        this.code = code;
        this.schemaNames = schemaNames;
    }

    public int getCode() {
        return code;
    }

    public static String[] getSchemaNames(int code) {
        String[] schemas = codeToSchemas.get(code);
        if (schemas == null) {
            throw new IllegalArgumentException("Unknown schema for code: " + code);
        }
        return schemas;
    }
}
