package ru.yandex.webmaster3.core.validator.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import ru.yandex.common.util.collections.Cf;
import ru.yandex.common.util.json.JsonConvertable;
import ru.yandex.common.util.json.Jsoner;
import ru.yandex.common.util.xml.Tagable;
import ru.yandex.common.util.xml.Xmler;

import java.util.HashMap;

/**
 * User: Vladislav Dolbilov (darl@yandex-team.ru)
 * Date: 19.03.12 14:26
 */
public class ErrorDescription implements Tagable, JsonConvertable {
    private Integer line = null;
    private Integer column = null;
    private String details;
    private ErrorSource errorSource;

    @JsonCreator
    public ErrorDescription(Integer line, Integer column, String details, ErrorSource errorSource) {
        this.line = line;
        this.column = column;
        this.details = details;
        this.errorSource = errorSource;
    }

    public ErrorDescription(String details, ErrorSource errorSource) {
        this.details = details;
        this.errorSource = errorSource;
    }

    @JsonProperty("line")
    public Integer getLine() {
        return line;
    }

    @JsonProperty("column")
    public Integer getColumn() {
        return column;
    }

    @JsonProperty("detail")
    public String getDetails() {
        return details;
    }

    @JsonProperty("err_source")
    public ErrorSource getErrorSource() {
        return errorSource;
    }

    @Override
    public Xmler.Tag asTag() {
        return Xmler.tag("error",
                Cf.list(
                        Xmler.tagOrEmpty("line", line != null ? line.toString() : null),
                        Xmler.tagOrEmpty("column", column != null ? column.toString() : null),
                        Xmler.tag("detail", details),
                        Xmler.tag("err_source", errorSource.name())
                ));
    }

    @Override
    public void toJson(StringBuilder storage) {
        final HashMap<String, String> map = new HashMap<>();
        map.put("line", line != null ? line.toString() : "");
        map.put("column", column != null ? column.toString() : null);
        map.put("detail", details);
        map.put("err_source", errorSource.name());
        Jsoner.object(map).toJson(storage);
    }

    @Override
    public String toString() {
        return "ErrorDescription{" +
                "line=" + line +
                ", column=" + column +
                ", details='" + details + '\'' +
                ", errorSource=" + errorSource +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ErrorDescription that = (ErrorDescription) o;
        return new EqualsBuilder()
                .append(column, that.column)
                .append(line, that.line)
                .isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder()
                .append(line)
                .append(column)
                .toHashCode();
    }
}
