package ru.yandex.webmaster3.core.worker;

import java.io.IOException;
import java.net.URI;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpStatus;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.springframework.web.util.UriComponentsBuilder;

import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.http.HttpConstants;
import ru.yandex.webmaster3.core.util.json.JsonMapping;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskInfo;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskType;

/**
 * Created by Oleg Bazdyrev on 23/08/2018.
 */
@Slf4j
public class WorkerApi {
    private static final int socketTimeoutMs = 10_000;
    private CloseableHttpClient httpClient;

    public void init() {
        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectionRequestTimeout(HttpConstants.DEFAULT_CONNECTION_REQUEST_TIMEOUT)
                .setConnectTimeout(HttpConstants.DEFAULT_CONNECT_TIMEOUT)
                .setSocketTimeout(socketTimeoutMs)
                .build();

        httpClient = HttpClients.custom()
                .setMaxConnTotal(60)
                .setMaxConnPerRoute(20)
                .setDefaultRequestConfig(requestConfig)
                .build();
    }
    /**
     * Получение инфы по последнему выполнению периодической таски указанного типа
     * @param periodicTaskType
     * @return
     */
    public PeriodicTaskInfo getPeriodicTaskInfo(String workerHost, PeriodicTaskType periodicTaskType) {
        URI uri = UriComponentsBuilder.fromUriString(workerHost).path("/internal/task/state.json")
                .queryParam("taskType", periodicTaskType).build().toUri();
        HttpGet get = new HttpGet(uri);
        try (CloseableHttpResponse response = httpClient.execute(get)) {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == HttpStatus.SC_OK) {
                JsonNode node = JsonMapping.OM.readTree(response.getEntity().getContent());
                String status = node.get("status").textValue();
                if (status.equals(ActionStatus.SUCCESS.name()) && node.get("data") != null) {
                    PeriodicTaskInfo result = JsonMapping.OM.treeToValue(node.get("data"), PeriodicTaskInfo.class);
                    return result;
                }
            }
            log.warn("Failed to periodic task info for host {}, statusCode {}", workerHost, statusCode);
        } catch (IOException e) {
            log.error("Failed to periodic task info for host " + workerHost, e);

        }
        return null;
    }
}
