package ru.yandex.webmaster3.core.worker.client;

import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;

import java.io.IOException;
import java.util.Collection;

/**
 * @author aherman
 */

public interface WorkerClient {
    public final static int TOTAL_WORKERS = 3;

    <TD extends WorkerTaskData> void enqueueTask(TD taskData);

    <TD extends WorkerTaskData> boolean checkedEnqueueTask(TD taskData);

    default <TD extends WorkerTaskData> boolean checkedEnqueueBatch(Collection<TD> batch) {
        for (TD td : batch) {
            if (!checkedEnqueueTask(td)) {
                return false;
            }
        }
        return true;
    }

    default <TD extends WorkerTaskData> void enqueueBatch(Collection<TD> batch) {

        for (TD td : batch) {
            enqueueTask(td);
        }
    }
}
