package ru.yandex.webmaster3.core.worker.task;

import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author aherman
 */
public abstract class AbstractUpdateArchiveTaskData extends WorkerTaskData {
    private final DateTime archiveDate;

    public AbstractUpdateArchiveTaskData(WebmasterHostId hostId, DateTime archiveDate) {
        super(hostId);
        this.archiveDate = archiveDate;
    }

    public AbstractUpdateArchiveTaskData(
            @JsonProperty("taskId") UUID taskId,
            @JsonProperty("hostId") WebmasterHostId hostId,
            @JsonProperty("archiveDate") DateTime archiveDate)
    {
        super(taskId, hostId);
        this.archiveDate = archiveDate;
    }

    public DateTime getArchiveDate() {
        return archiveDate;
    }

}
