package ru.yandex.webmaster3.core.worker.task;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.UUID;

/**
 * @author tsyplyaev
 */
public class ChangeMainMirrorTaskData extends WorkerTaskData {
    public ChangeMainMirrorTaskData(WebmasterHostId hostId) {
        super(hostId);
    }

    public ChangeMainMirrorTaskData(
            @JsonProperty("taskId") UUID taskId,
            @JsonProperty("hostId") WebmasterHostId hostId)
    {
        super(taskId, hostId, WorkerTaskPriority.NORMAL, true);
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.CHANGE_MAIN_MIRROR;
    }

    @Override
    public String getShortDescription() {
        return getHostId().toStringId();
    }
}
