package ru.yandex.webmaster3.core.worker.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.UUID;

/**
 * @author leonidrom
 */
public class HostMobileAuditTaskData extends WorkerTaskData {
    public HostMobileAuditTaskData(WebmasterHostId hostId) {
        super(hostId);
    }

    @JsonCreator
    public HostMobileAuditTaskData(
            @JsonProperty("taskId") UUID taskId,
            @JsonProperty("hostId") WebmasterHostId hostId)
    {
        super(taskId, hostId);
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.HOST_MOBILE_AUDIT;
    }

    @Override
    public String getShortDescription() {
        return "Host mobile audit for " + getHostId();
    }
}
