package ru.yandex.webmaster3.core.worker.task;

import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author avhaliullin
 */
public class InitializeHostTaskData extends WorkerTaskData {
    public InitializeHostTaskData(
            @JsonProperty("taskId") UUID taskId,
            @JsonProperty("hostId") WebmasterHostId hostId)
    {
        super(taskId, hostId);
    }

    public InitializeHostTaskData(WebmasterHostId hostId) {
        super(hostId);
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.INITIALIZE_HOST;
    }

    @Override
    public String getShortDescription() {
        return "Runs all needed tasks when host added to service";
    }
}
