package ru.yandex.webmaster3.core.worker.task;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.IdUtils;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class InitializeUserTaskData extends WorkerTaskData {
    private final long userId;
    private final EmailInitMode emailInitMode;
    private final String providedEmail;
    //TODO: Нужны только на период миграции
    private final Boolean allowSearchBaseMessages;
    private final Boolean allowSearchBaseEmails;

    public InitializeUserTaskData(
            @JsonProperty("taskId") UUID taskId,
            @JsonProperty("hostId") WebmasterHostId hostId,
            @JsonProperty("userId") long userId,
            @JsonProperty("emailInitMode") EmailInitMode emailInitMode,
            @JsonProperty("providedEmail") String providedEmail,
            @JsonProperty("allowSearchBaseMessages") Boolean allowSearchBaseMessages,
            @JsonProperty("allowSearchBaseEmails") Boolean allowSearchBaseEmails
    ) {
        super(taskId, hostId);
        this.userId = userId;
        this.emailInitMode = emailInitMode;
        this.providedEmail = providedEmail;
        this.allowSearchBaseMessages = allowSearchBaseMessages;
        this.allowSearchBaseEmails = allowSearchBaseEmails;
    }

    public InitializeUserTaskData(long userId, EmailInitMode emailInitMode, String providedEmail,
                                  Boolean allowSearchBaseMessages, Boolean allowSearchBaseEmails) {
        //Костыль - все воркерные таски требуют hostId, а нам он тут и не нужен
        super(IdUtils.stringToHostId("http:example.com:80"));
        this.userId = userId;
        this.emailInitMode = emailInitMode;
        this.providedEmail = providedEmail;
        this.allowSearchBaseMessages = allowSearchBaseMessages;
        this.allowSearchBaseEmails = allowSearchBaseEmails;
    }

    public Boolean isAllowSearchBaseEmails() {
        return allowSearchBaseEmails;
    }

    public Boolean isAllowSearchBaseMessages() {
        return allowSearchBaseMessages;
    }

    public EmailInitMode getEmailInitMode() {
        return emailInitMode;
    }

    public String getProvidedEmail() {
        return providedEmail;
    }

    public long getUserId() {
        return userId;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.INITIALIZE_USER;
    }

    @Override
    public String getShortDescription() {
        return "Initializing settings for user";
    }

    public enum EmailInitMode {
        NONE,
        PROVIDED,
        DEFAULT,
    }
}
