package ru.yandex.webmaster3.core.worker.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.metrika.counters.CounterBindingStateEnum;
import ru.yandex.webmaster3.core.metrika.counters.CounterRequestTypeEnum;

/**
 * @author leonidrom
 */
@Getter
public class MetrikaCounterBindingStateChangeTaskData extends WorkerTaskData {
    private final CounterRequestTypeEnum metrikaEvent;
    private final String domain;
    private final long initiatorId;
    private final String initiatorLogin;
    private final long counterId;
    private final CounterBindingStateEnum prevState;
    private final CounterBindingStateEnum state;
    private final DateTime eventTime;

    @JsonCreator
    public MetrikaCounterBindingStateChangeTaskData(
            @JsonProperty("metrikaEvent") CounterRequestTypeEnum metrikaEvent,
            @JsonProperty("domain") String domain,
            @JsonProperty("userId") long initiatorId,
            @JsonProperty("userLogin") String initiatorLogin,
            @JsonProperty("counterId") long counterId,
            @JsonProperty("prevState") CounterBindingStateEnum prevState,
            @JsonProperty("state") CounterBindingStateEnum state,
            @JsonProperty("eventTime") DateTime eventTime) {

        this.metrikaEvent = metrikaEvent;
        this.domain = domain;
        this.initiatorId = initiatorId;
        this.initiatorLogin = initiatorLogin;
        this.counterId = counterId;
        this.prevState = prevState;
        this.state = state;
        this.eventTime = eventTime;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.METRIKA_COUNTER_BINDING_CHANGE;
    }

    @Override
    public String getShortDescription() {
        return "";
    }
}
