package ru.yandex.webmaster3.core.worker.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.webmaster3.core.metrika.counters.CounterRequestTypeEnum;

/**
 * ishalaru
 * 25.12.2020
 **/
public class MetrikaCounterBindingTaskData extends WorkerTaskData {
    private final CounterRequestTypeEnum metrikaEvent;
    private final String domain;
    private final long initiatorId;
    private final String initiatorLogin;
    private final long counterId;

    @JsonCreator
    public MetrikaCounterBindingTaskData(@JsonProperty("metrikaEvent") CounterRequestTypeEnum metrikaEvent,
                                         @JsonProperty("domain") String domain,
                                         @JsonProperty("userId") long initiatorId,
                                         @JsonProperty("userLogin") String initiatorLogin,
                                         @JsonProperty("counterId") long counterId) {
        this.metrikaEvent = metrikaEvent;
        this.domain = domain;
        this.initiatorId = initiatorId;
        this.initiatorLogin = initiatorLogin;
        this.counterId = counterId;
    }

    public CounterRequestTypeEnum getMetrikaEvent() {
        return metrikaEvent;
    }

    public String getDomain() {
        return domain;
    }

    public long getInitiatorId() {
        return initiatorId;
    }

    public String getInitiatorLogin() {
        return initiatorLogin;
    }

    public long getCounterId() {
        return counterId;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.METRIKA_COUNTER_BINDING;
    }

    @Override
    public String getShortDescription() {
        return "Таска об изменениях привязки счетчика метрики";
    }
}
