package ru.yandex.webmaster3.core.worker.task;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class MobileAuditForUrlTaskData extends WorkerTaskData {
    private final long userId;

    public MobileAuditForUrlTaskData(@JsonProperty("taskId") UUID taskId,
                                     @JsonProperty("userId") long userId,
                                     @JsonProperty("hostId") WebmasterHostId hostId) {
        super(taskId, hostId);
        this.userId = userId;
    }

    public long getUserId() {
        return userId;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.MOBILE_AUDIT_FOR_URL;
    }

    @Override
    public String getShortDescription() {
        return null;
    }
}
