package ru.yandex.webmaster3.core.worker.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

/**
 * Created by Oleg Bazdyrev on 22/08/2018.
 */
public class PeriodicTaskInfo {

    private final Object state;
    private final boolean running;

    private volatile String schedule;
    private volatile String lastStarted;
    private volatile String lastFinished;
    private volatile long lastRunTimeMs;
    private volatile TaskResult lastResult;

    @JsonCreator
    public PeriodicTaskInfo(Object state, boolean running, String schedule, String lastStarted, String lastFinished,
                            long lastRunTimeMs, TaskResult lastResult) {
        this.state = state;
        this.running = running;
        this.schedule = schedule;
        this.lastStarted = lastStarted;
        this.lastFinished = lastFinished;
        this.lastRunTimeMs = lastRunTimeMs;
        this.lastResult = lastResult;
    }

    public PeriodicTaskInfo(Object state, boolean running, String schedule, DateTime lastStarted, DateTime lastFinished,
                            long lastRunTimeMs, TaskResult lastResult) {
        this.state = state;
        this.running = running;
        this.schedule = schedule;
        DateTimeFormatter dtf = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss"); // middle endian - зло
        this.lastStarted = (lastStarted != null) ? dtf.print(lastStarted) : null;
        this.lastFinished = (lastFinished != null) ? dtf.print(lastFinished) : null;
        this.lastRunTimeMs = lastRunTimeMs;
        this.lastResult = lastResult;
    }

    public Object getState() {
        return state;
    }

    public boolean isRunning() {
        return running;
    }

    public String getSchedule() {
        return schedule;
    }

    public String getLastStarted() {
        return lastStarted;
    }

    public String getLastFinished() {
        return lastFinished;
    }

    public long getLastRunTimeMs() {
        return lastRunTimeMs;
    }

    public TaskResult getLastResult() {
        return lastResult;
    }

}
