package ru.yandex.webmaster3.core.worker.task;

import ru.yandex.webmaster3.core.util.enums.EnumResolver;

/**
 * @author aherman
 */
public enum PeriodicTaskType {
    UNKNOWN,

    URL_STATE_UPDATE,
    CHANGE_MAIN_MIRROR_PERIODIC,
    EXTENDED_HTTP_CODES_EXPORT,
    MDB_HOST_FAVICON_IMPORT,

    HOST_REGION_UPLOAD,
    MORDA_INFO_UPDATE,
    ROBOTS_TXT_INFO_UPDATE,
    SERP_LINKS_CHANGES_COLLECTOR,
    SITE_PROBLEMS_CLEAN,
    EXPORT_FORCE_SITEMAP_QUEUE,
    IMPORT_HOST_STATISTICS,
    IMPORT_HOST_PROBLEMS,
    IMPORT_HOST_REGIONS,
    UPLOAD_HOST_DISPLAY_NAMES,
    UPLOAD_QUERY_GROUPS,
    UPLOAD_USER_NODES,
    UPLOAD_USER_SITEMAPS,
    UPLOAD_WEBMASTER_HOSTS_SPECIFIC,
    UPLOAD_WEBMASTER_ALL_HOSTS,
    UPLOAD_WEBMASTER_VERIFIED_HOSTS,
    UPLOAD_WEBMASTER_UNVERIFIED_HOSTS,
    UPLOAD_USER_LAST_VISIT,
    UPLOAD_USER_HOST_VERIFICATIONS,
    UPLOAD_WEBMASTER_HOSTS_WITH_IMPORTANT_URLS,
    CLEANUP_NOTIFICATIONS,
    INITIALIZE_ALL_USERS,
    EMAILS_VERIFICATION_STATE_UPDATE,
    UPLOAD_NEW_WEBMASTER_HOSTS,
    SEND_SEARCH_BASE_UPDATE_NOTIFICATION,
    PREPARE_SEARCH_BASE_NOTIFICATION_LIST,
    UPLOAD_MIRROR_REQUESTS,
    RECHECK_VERIFICATIONS_TASK,
    CLEAN_DELEGATION_TASK,
    EXPORT_DELURL_PREFIXES,
    CHECK_JUPITER_BASE_UPDATE,
    EXPORT_THREAT_RECHECKS,
    EXPORT_THREAT_FORCE_RECHECKS,

    MDB_IMPORT_SEARCH_URL_SAMPLES,
    MDB_IMPORT_SEARCH_URL_EVENT_SAMPLES,
    MDB_CREATE_SEARCH_URL_EMAIL_SAMPLES,
    MDB_IMPORT_EXCLUDED_URL_SAMPLES,

    MDB_IMPORT_MIRRORS,
    MDB_IMPORT_MIRRORS2,
    MDB_IMPORT_DISPLAY_NAMES,
    MDB_IMPORT_MIRRORS_CHANGES,
    MDB_IMPORT_DISPLAY_NAME_CHANGES,

    EXPORT_DAILY_USER_MESSAGES,

    MDB_CLEANUP_SEARCH_BASE_IMPORTS,
    ADD_SPAM_BAN_RULES,

    MDB_IMPORT_INDEXED_SAMPLES,
    MDB_IMPORT_INDEXING_EVENT_SAMPLES,
    MDB_IMPORT_INDEXED_URLS_COUNT,
    MDB_IMPORT_INDEXING_EVENTS_COUNT,

    YT_TO_MDB_CLICKHOUSE_IMPORT,
    MDB_CLICKHOUSE_REPLICATE_TABLES,

    URL_CHECK_PROCESS_YT_REQUESTS,
    URL_CHECK_PROCESS_YT_RESULTS,

    MDB_IMPORT_EXTENDED_RECOMMENDED_QUERIES,
    MDB_IMPORT_RECOMMENDED_QUERIES,
    IMPORT_DOMAINS_WITH_DIRECT_DYN_ADS,
    MDB_IMPORT_RECOMMENDED_URLS,

    // важные страницы
    IMPORTANT_URLS_EXPORT,
    // важные страницы v2
    IMPORTANT_URLS_AUTO_ADD,
    // важные страницы MDB
    MDB_IMPORTANT_URLS_HISTORY_IMPORT,
    MDB_IMPORTANT_URLS_LAST_STATE_IMPORT,
    MDB_IMPORTANT_URLS_CHANGES_IMPORT,

    // задачи импорта поисковых запросов (MDB)
    MDB_SEARCH_QUERIES_IMPORT_GROUP,
    MDB_SEARCH_QUERIES_IMPORT_FAVORITE,
    MDB_SEARCH_QUERIES_IMPORT_TOP,
    MDB_SEARCH_QUERIES_IMPORT_WEEK,
    MDB_SEARCH_QUERIES_IMPORT_TOP_URLS,
    MDB_SEARCH_QUERIES_SWITCH_DATES,

    UPDATE_SPAM_HOSTS,
    BAN_SPAM_OWNERS_TASK,

    // импорт ссылок
    MDB_LINKS_LOAD_INTERNAL,
    MDB_LINKS_LOAD_EXTERNAL,
    MDB_LINKS_LOAD_EXTERNAL_GONE,
    MDB_LINKS_SWITCH_DATES,
    MDB_LINKS_STATISTICS_LOAD,
    IMPORT_BROKEN_LINK_SAMPLES,

    MDB_CLEAN_CLICKHOUSE_TABLES,

    MDB_IMPORT_SITE_STRUCTURES_CH,
    IMPORT_LAST_SITE_STRUCTURES,

    MDB_MERGE_USER_MESSAGES3,

    MDB_IMPORT_OWNER_THREATS,

    IMPORT_METRIKA_STATUS,
    UPLOAD_METRIKA_CRAWL_SETTINGS,

    MERGE_SANCTIONS,

    UPLOAD_USER_NOTIFICATION_SETTINGS,
    DIGEST_SITE_PROBLEMS,
    POST_WELCOME_EMAIL_NOTIFICATION,
    UPLOAD_SEARCH_BASE_UPDATES,

    PREPARE_DIGEST_NOTIFICATION,
    START_DIGEST_NOTIFICATION,

    UPLOAD_ADD_URL_EVENT_LOGS,

    // Turbo
    EXPORT_TURBO_FEEDS,
    EXPORT_TURBO_FEEDS_SETTINGS,
    IMPORT_TURBO_HOST_BANS,
    EXPORT_TURBO_HOST_BANS_RECHECKS,
    IMPORT_TURBO_STATS,
    UPDATE_TURBO_INSUFFICIENT_CLICKS_SHARE,
    IMPORT_TURBO_SEARCH_STATS,
    IMPORT_TURBO_API_RESULTS,
    IMPORT_TURBO_AUTOPARSED_HOSTS,
    EXPORT_TURBO_AUTOPARSE_FLAGS,
    PROCESS_TURBO_AUTOPARSER_SCREENSHOTS,
    IMPORT_TURBO_AUTOPARSED_HOSTS_SPEEDS,
    IMPORT_TURBO_CMNT_URLS_STATE,
    EXPORT_TURBO_CMNT_STATUS,
    VALIDATE_CART_URLS_FOR_TURBO,
    IMPORT_TURBO_DOMAINS_STATE,
    TURBO_ADV_POSTPONED_CREATION,
    IMPORT_TURBO_SCC_PREMODERATION_STATUS,
    IMPORT_TURBO_SCC_PREMODERATION_DICT,
    MDB_IMPORT_RIVALS_STATS2,
    IMPORT_TURBO_AUTO_DELETED_PAGES_SAMPLES,
    IMPORT_TURBO_AUTO_DELETED_PAGES,
    EXPORT_TURBO_AUTO_ADV_STATUS,

    MDB_IMPORT_TURBO_SEARCHURLS_STATS,
    MDB_IMPORT_TURBO_SEARCHURLS_SAMPLES,
    MDB_IMPORT_TURBO_CLICK_DAY_STATS,
    MDB_IMPORT_TURBO_DOMAINS_STATE,
    MDB_IMPORT_TURBO_FEEDS_HISTORY,

    UPLOAD_HOSTS_WITH_OPENED_RECOMMENDED,
    CLOSE_RECOMMENDED_QUERIES,
    SEND_NOTIFICATIONS_ABOUT_OPEN_RECOMMENDED,

    HOST_DISPLAY_NAME_MODERATION_PROCESS_YT_REQUESTS,
    HOST_DISPLAY_NAME_MODERATION_PROCESS_YT_RESULTS,
    HOST_DISPLAY_NAME_MODERATION_RESEND_LOST_REQUESTS,

    HOST_REGIONS_MODERATION_PROCESS_YT_REQUESTS,
    HOST_REGIONS_MODERATION_PROCESS_YT_RESULTS,
    HOST_REGIONS_MODERATION_RESEND_LOST_REQUESTS,

    UPLOAD_METRIKA_COUNTER_LINKS,
    METRIKA_CLEAR_COUNTERS_IN_TESTING,

    UPDATE_YABROWSER_BADADS,
    UPLOAD_YABROWSER_BADADS_RECHECKS,

    SEND_NOTIFICATIONS_ACCESS_DELEGATION,

    IMPORT_COMPANY_PROFILE_INFO,
    SEND_NOTIFICATIONS_NOT_FILL_COMPANY_PROFILE,

    UPLOAD_BASE_CRAWL_INFO,
    EXPORT_USER_CRAWL_SETTINGS,
    EXPORT_ROTOR_SETTINGS,

    EXPORT_METRIKA_RADAR,
    IMPORT_RADAR_THEMATICS,

    IMPORT_COMMERCIAL_OWNERS,

    MDB_IMPORT_IKS,
    MDB_IMPORT_IKS_HISTORY,
    EXPORT_IKS_RIVALS,
    UPDATE_IKS_VALUE,
    SEND_IKS_RIVALS_NOTIFICATION,
    SEND_IKS_PUSH_NOTIFICATION,

    IMPORT_MEMORANDUM_DATA,
    MDB_IMPORT_MEMORANDUM_DATA,

    IMPORT_ROBOTS_TXT,

    MDB_IMPORT_DOMAINS_ON_SEARCH,

    MDB_IMPORT_ACHIEVEMENTS,
    MDB_IMPORT_ACHIEVEMENTS_KUUB,

    MDB_IMPORT_SITE_SERVICES,

    UPDATE_MAIN_MIRRORS_IS_NOT_HTTPS_PROBLEMS,
    IMPORT_SSL_CERTIFICATE_ERRORS,

    IMPORT_EU_EMAILS,

    //TMP:
    TEST_TASK,
    UPLOAD_PVL_DOMAINS_TEMP,

    EXPORT_FEEDBACK,


    MDB_IMPORT_METRIKA_CRAWL_SAMPLES,
    MDB_IMPORT_METRIKA_STATS_BY_TIME,


    IMPORT_METRIKA_CRAWL_SAMPLES_INFO,
    UPDATE_METRIKA_CRAWL_PROBLEMS,
    UPDATE_METRIKA_BINDING_PROBLEMS,
    IMPORT_METRIKA_CRAWL_LOST_HITS_SAMPLES,

    IMPORT_EXPERIMENTS,
    IMPORT_REVIEW,
    CLEAN_UNVERIFIED_HOSTS,
    POSTPONED_VERIFY_HOST,
    UNVERIFIED_HOSTS_REMOVAL_WARNING,
    HOST_MOBILE_AUDIT_RESEND_STALE_REQUESTS,
    IMPORT_MIRROR_CHANGE_DISALLOWED_OWNERS,

    UPLOAD_SITE_PROBLEMS,
    IMPORT_MASS_MEDIA_DICT,
    EXPORT_APPROVED_MASS_MEDIA,

    IMPORT_TURBO_MARKET_FEEDS,

    EXPORT_DASHBOARD_SURVEY,
    USER_TAKEOUT_CHECK,
    IMPORT_INSIGNIFICANT_CGI_PARAMETER,
    REMOVE_OLD_FRESH_DATA,
    IMPORT_CALLISTO_FRESH_INFO,
    IMPORT_WEBMASTER_HOSTS,
    IMPORT_MONSTER_HOSTS,
    ADDURL_RESEND_STALE_REQUESTS,
    DELURL_RESEND_STALE_REQUESTS,
    MDB_IMPORT_ALL_MIRRORS,
    UPDATE_HOST_MOBILE_AUDIT_RESULTS_OVERRIDE,
    IMPORT_GROUP_LIMITS,
    IMPORT_NICHE_RIVALS,
    IMPORT_NICHE_QUERIES,
    IMPORT_NICHE_RIVAL_QUERIES,
    IMPORT_NICHE_RIVAL_QUERIES_REPORT,
    IMPORT_NICHE2_RIVAL_REPORT,
    IMPORT_NICHE2_QUERIES_REPORT,
    IMPORT_SITEMAPS,
    IMPORT_SITEMAP_PROBLEMS,
    SEND_REPEATED_CHECKLIST_NOTIFICATIONS,
    AUTO_VERIFICATION_ON_MIGRATION,
    ENABLE_REALTIME_URL_ALERT_4XX,
    ENABLE_REALTIME_URL_ALERT_5XX,
    DISABLE_REALTIME_URL_ALERT_4XX,
    DISABLE_REALTIME_URL_ALERT_5XX,

    FEEDS_IMPORT_EXTERNAL_FEEDS,
    FEEDS_EXPORT_DOMAINS_INFO_FEEDS,
    FEEDS_EXPORT_NATIVE_FEEDS,
    FEEDS_EXPORT_TV_FEEDS,
    FEEDS_EXPORT_UNISEARCH_MODERATION_FEEDS,
    FEEDS_IMPORT_PARSING_RESULT,
    FEEDS_IMPORT_FAST_CHECK_PARSING_RESULT,
    FEEDS_EXPORT_UNISEARCH_FEEDS,
    FEEDS_EXPORT_FEEDS_INFO,
    IMPORT_DISALLOWED_URLS,
    IMPORT_CURRENT_SERP_DATA,
    IMPORT_FEEDS_OFFERS_LOGS_HISTORY,
    IMPORT_GOODS_OFFERS_LOGS_HISTORY,
    IMPORT_SERPDATA_LOGS_HISTORY,
    IMPORT_DEFECT_RATE_STATE,
    IMPORT_FEEDS_OFFERS_STATISTICS,
    IMPORT_FEEDS_OFFER_BANS,
    IMPORT_MARKET_OFFERS_STATISTICS,
    PREPARE_FEEDS_CLICKS_STATISTICS,
    IMPORT_FEEDS_ENRICHED_SHOWS,
    IMPORT_FEEDS_NOT_ENRICHABLE_SHOWS,
    FEEDS_UPDATE_PROBLEMS,

    UPLOAD_VIDEOHOST_OFFER,
    UPDATE_VIDEOHOST_OFFER_STATUS,
    UPDATE_VIDEOHOSTS_LIST,
    VIDEOHOST_OFFER_IS_NEEDED_NOTIFICATION,

    SEND_NOT_MAIN_MIRROR_EMAIL,
    SCRAPE_FOR_TAKEOUT_YDB_TABLES,
    SCRAPE_FOR_TAKEOUT_YT_DIRS,
    DELETE_YT_USER_DATA,
    SEND_NCA_CERTIFICATE_NOTIFICATION,
    IMPORT_DOMAINS_WITH_NCA_CERTIFICATE,
    PARSER_CERTIFICATE_TRANSPARENCY_LOGS,
    ;

    public static final EnumResolver<PeriodicTaskType> R = EnumResolver.er(PeriodicTaskType.class);

}
