package ru.yandex.webmaster3.core.worker.task;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class SendMirrorChangeNotificationTaskData extends WorkerTaskData {
    private final WebmasterHostId oldMirror;
    private final WebmasterHostId newMirror;

    public SendMirrorChangeNotificationTaskData(WebmasterHostId hostId, WebmasterHostId oldMirror, WebmasterHostId newMirror) {
        super(hostId);
        this.oldMirror = oldMirror;
        this.newMirror = newMirror;
    }

    public SendMirrorChangeNotificationTaskData(
            @JsonProperty("taskId") UUID taskId,
            @JsonProperty("hostId") WebmasterHostId hostId,
            @JsonProperty("oldMirror") WebmasterHostId oldMirror,
            @JsonProperty("newMirror") WebmasterHostId newMirror) {
        super(taskId, hostId);
        this.oldMirror = oldMirror;
        this.newMirror = newMirror;
    }

    public WebmasterHostId getOldMirror() {
        return oldMirror;
    }

    public WebmasterHostId getNewMirror() {
        return newMirror;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.SEND_MIRROR_CHANGE_NOTIFICATION;
    }

    @Override
    public String getShortDescription() {
        return "send 'main mirror changed' notification to users";
    }
}
