package ru.yandex.webmaster3.core.worker.task;

import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author avhaliullin
 */
public class SerpLinksCheckerTaskData extends WorkerTaskData {
    public SerpLinksCheckerTaskData(
            @JsonProperty("taskId") UUID taskId,
            @JsonProperty("hostId") WebmasterHostId hostId)
    {
        super(taskId, hostId);
    }

    public SerpLinksCheckerTaskData(WebmasterHostId hostId) {
        super(hostId);
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.CHECK_SERPLINKS;
    }

    @Override
    public String getShortDescription() {
        return "Actualizes NoSerpLinks problem status";
    }
}
