package ru.yandex.webmaster3.core.worker.task;

import com.fasterxml.jackson.annotation.JsonProperty;


/**
 * Created by leonidrom on 23/05/2017.
 */
public class SitemapRecrawlTaskData extends WorkerTaskData {
    private final String sitemapUrl;

    public SitemapRecrawlTaskData(@JsonProperty("sitemapUrl") String sitemapUrl) {
        this.sitemapUrl = sitemapUrl;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.RECRAWL_SITEMAP;
    }

    @Override
    public String getShortDescription() {
        return "Sitemap recrawl: " + sitemapUrl;
    }

    public String getSitemapUrl() {
        return sitemapUrl;
    }
}
