package ru.yandex.webmaster3.core.worker.task;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class SyncVerificationStateTaskData extends WorkerTaskData {
    private final long userId;

    public SyncVerificationStateTaskData(
            @JsonProperty("taskId") UUID taskId,
            @JsonProperty("hostId") WebmasterHostId hostId,
            @JsonProperty("userId") long userId
    ) {
        super(taskId, hostId);
        this.userId = userId;
    }

    public SyncVerificationStateTaskData(WebmasterHostId hostId, long userId) {
        super(hostId);
        this.userId = userId;
    }

    public long getUserId() {
        return userId;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.SYNC_VERIFICATION_STATE;
    }

    @Override
    public String getShortDescription() {
        return null;
    }
}
