package ru.yandex.webmaster3.core.worker.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;

import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * ishalaru
 * 18.12.2020
 **/
public class TurboAdv4BoxTaskData extends WorkerTaskData {
    @Getter
    private final Long userId;
    @Getter
    private final WebmasterHostId hostId;

    @JsonCreator
    public TurboAdv4BoxTaskData(@JsonProperty("userId") Long userId, @JsonProperty("hostId") WebmasterHostId hostId) {
        this.userId = userId;
        this.hostId = hostId;

    }


    @Override
    public WorkerTaskPriority getTaskPriority() {
        return WorkerTaskPriority.HIGH;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.TURBO_ADV_FROM_BOX;
    }

    @Override
    public String getShortDescription() {
        return "Данные для заведения рекламы из коробки";
    }
}
