package ru.yandex.webmaster3.core.worker.task;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.addurl.RecrawlState;
import ru.yandex.webmaster3.core.addurl.UrlForRecrawl;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.UUID;

/**
 * @author leonidrom
 */
@Getter
public class UrlRecrawlTaskData extends WorkerTaskData {
    private final UUID urlId;
    private final String relativeUrl;
    private final DateTime addDate;

    public UrlRecrawlTaskData(
            @JsonProperty("hostId") WebmasterHostId hostId,
            @JsonProperty("urlId") UUID urlId,
            @JsonProperty("relativeUrl") String relativeUrl,
            @JsonProperty("addDate") DateTime addDate) {
        super(hostId, WorkerTaskPriority.NORMAL, true);
        this.urlId = urlId;
        this.relativeUrl = relativeUrl;
        this.addDate = addDate;
    }

    public static UrlRecrawlTaskData fromUrlForRecrawl(UrlForRecrawl urlForRecrawl) {
        return new UrlRecrawlTaskData(urlForRecrawl.getHostId(), urlForRecrawl.getUrlId(),
                urlForRecrawl.getRelativeUrl(), urlForRecrawl.getAddDate());
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.RECRAWL_URL_SAMOVAR;
    }

    @Override
    public String getShortDescription() {
        return "Recrawl url: " + urlId;
    }

    @JsonIgnore
    public UrlForRecrawl getUrlForRecrawl() {
        return new UrlForRecrawl(getHostId(), getUrlId(), getRelativeUrl(), getAddDate(), getAddDate(), RecrawlState.NEW);
    }
}
