package ru.yandex.webmaster3.core.worker.task;

import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.user.takeout.UserTakeoutRequestType;

/**
 * @author leonidrom
 * <p>
 * Обработка запроса на пользовательскую выгрузку по GDPR
 */
public class UserTakeoutTaskData extends WorkerTaskData {
    private final long userId;
    private final UUID requestId;
    private final UserTakeoutRequestType requestType;

    /**
     * @param userId    пользователь, для которого надо сделать выгрузку
     * @param requestId уникальный id запроса на выгрузку
     */
    public UserTakeoutTaskData(
            @JsonProperty("userId") long userId,
            @JsonProperty("requestId") UUID requestId,
            @JsonProperty("requestType") UserTakeoutRequestType requestType) {
        super(requestId, null);
        this.userId = userId;
        this.requestId = requestId;
        this.requestType = requestType;
    }

    public long getUserId() {
        return userId;
    }

    public UUID getRequestId() {
        return requestId;
    }

    public UserTakeoutRequestType getRequestType() {
        return requestType;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.USER_TAKEOUT;
    }

    @Override
    public String getShortDescription() {
        return null;
    }

    @Override
    public WorkerTaskPriority getTaskPriority() {
        return WorkerTaskPriority.HIGHEST;
    }

    @Override
    public int getRetryCount() {
        return 5;
    }
}
