package ru.yandex.webmaster3.core.worker.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * ishalaru
 * 12.01.2021
 **/
public class UserVerifiesHostTaskData extends WorkerTaskData {
    private final long userId;
    private final WebmasterHostId hostId;
    private final boolean isNewHost;

    @JsonCreator
    public UserVerifiesHostTaskData(
            @JsonProperty("userId") long userId,
            @JsonProperty("hostId") WebmasterHostId hostId,
            @JsonProperty("isNewHost") boolean isNewHost) {
        this.userId = userId;
        this.hostId = hostId;
        this.isNewHost = isNewHost;
    }

    public long getUserId() {
        return userId;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.USER_VERIFIES_HOST;
    }

    @Override
    public String getShortDescription() {
        return "";
    }

    public boolean isNewHost() {
        return isNewHost;
    }
}
